﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
''' 一个用于选择目录的简单控件
''' </summary>
''' <remarks></remarks>
Public Class DirectoryChooser

    ''' <summary>
    ''' 已选择哪个目录？
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public ReadOnly Property Directory() As String
        Get
            Return Me.FileTextBox.Text
        End Get
    End Property


    ''' <summary>
    ''' 用用户选择的目录填充 TextBox/
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub FileBrowseButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FileBrowseButton.Click
        Dim folderDialog As New FolderBrowserDialog
        folderDialog.RootFolder = Environment.SpecialFolder.MyComputer
        If (folderDialog.ShowDialog() = DialogResult.OK) Then
            Me.FileTextBox.Text = folderDialog.SelectedPath
        End If
    End Sub

    ''' <summary>
    ''' 重置所选目录
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Reset()
        Me.FileTextBox.Text = String.Empty
    End Sub
End Class
